/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.crf.CRFCliqueTree;
import edu.stanford.nlp.ie.crf.CRFLabel;
import edu.stanford.nlp.ie.crf.CliquePotentialFunction;
import edu.stanford.nlp.ie.crf.HasCliquePotentialFunction;
import edu.stanford.nlp.ie.crf.NonLinearSecondOrderCliquePotentialFunction;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.optimization.AbstractCachingDiffFunction;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.Quadruple;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class CRFNonLinearSecondOrderLogConditionalObjectiveFunction
extends AbstractCachingDiffFunction
implements HasCliquePotentialFunction {
    private static Redwood.RedwoodChannels log = Redwood.channels(CRFNonLinearSecondOrderLogConditionalObjectiveFunction.class);
    public static final int NO_PRIOR = 0;
    public static final int QUADRATIC_PRIOR = 1;
    public static final int HUBER_PRIOR = 2;
    public static final int QUARTIC_PRIOR = 3;
    boolean useOutputLayer;
    boolean useHiddenLayer;
    boolean useSigmoid;
    SeqClassifierFlags flags;
    int count = 0;
    protected int prior;
    protected double sigma;
    protected double epsilon;
    Random random = new Random(Integer.MAX_VALUE);
    List<Index<CRFLabel>> labelIndices;
    Index<String> classIndex;
    double[][] Ehat;
    double[][] Uhat;
    double[][] What;
    int window;
    int numClasses;
    int numHiddenUnits;
    int[] map;
    int[][][][] data;
    int[][] docWindowLabels;
    int[][] labels;
    int domainDimension = -1;
    int inputLayerSize = -1;
    int outputLayerSize = -1;
    int inputLayerSize4Edge = -1;
    int outputLayerSize4Edge = -1;
    int edgeParamCount = -1;
    int numNodeFeatures = -1;
    int numEdgeFeatures = -1;
    int beforeOutputWeights = -1;
    int originalFeatureCount = -1;
    int[][] weightIndices;
    String crfType = "maxent";
    String backgroundSymbol;
    public static boolean VERBOSE = false;

    public static int getPriorType(String priorTypeStr) {
        if (priorTypeStr == null) {
            return 1;
        }
        if ("QUADRATIC".equalsIgnoreCase(priorTypeStr)) {
            return 1;
        }
        if ("HUBER".equalsIgnoreCase(priorTypeStr)) {
            return 2;
        }
        if ("QUARTIC".equalsIgnoreCase(priorTypeStr)) {
            return 3;
        }
        if (priorTypeStr.equalsIgnoreCase("NONE")) {
            return 0;
        }
        throw new IllegalArgumentException("Unknown prior type: " + priorTypeStr);
    }

    CRFNonLinearSecondOrderLogConditionalObjectiveFunction(int[][][][] data, int[][] labels, int window, Index classIndex, List<Index<CRFLabel>> labelIndices, int[] map, SeqClassifierFlags flags, int numNodeFeatures, int numEdgeFeatures) {
        this(data, labels, window, classIndex, labelIndices, map, 1, flags, numNodeFeatures, numEdgeFeatures);
    }

    CRFNonLinearSecondOrderLogConditionalObjectiveFunction(int[][][][] data, int[][] labels, int window, Index<String> classIndex, List<Index<CRFLabel>> labelIndices, int[] map, int prior, SeqClassifierFlags flags, int numNodeFeatures, int numEdgeFeatures) {
        this.window = window;
        this.classIndex = classIndex;
        this.numClasses = classIndex.size();
        this.labelIndices = labelIndices;
        this.data = data;
        this.flags = flags;
        this.map = map;
        this.labels = labels;
        this.prior = prior;
        this.backgroundSymbol = flags.backgroundSymbol;
        this.sigma = flags.sigma;
        this.outputLayerSize = this.numClasses;
        this.outputLayerSize4Edge = this.numClasses * this.numClasses;
        this.numHiddenUnits = flags.numHiddenUnits;
        this.inputLayerSize = this.numHiddenUnits * this.numClasses;
        this.inputLayerSize4Edge = this.numHiddenUnits * this.numClasses * this.numClasses;
        this.numNodeFeatures = numNodeFeatures;
        this.numEdgeFeatures = numEdgeFeatures;
        this.useOutputLayer = flags.useOutputLayer;
        this.useHiddenLayer = flags.useHiddenLayer;
        this.useSigmoid = flags.useSigmoid;
        this.docWindowLabels = new int[data.length][];
        if (!this.useOutputLayer) {
            log.info("Output layer not activated, inputLayerSize must be equal to numClasses, setting it to " + this.numClasses);
            this.inputLayerSize = this.numClasses;
            this.inputLayerSize4Edge = this.numClasses * this.numClasses;
        } else if (flags.softmaxOutputLayer && !flags.sparseOutputLayer && !flags.tieOutputLayer) {
            throw new RuntimeException("flags.softmaxOutputLayer == true, but neither flags.sparseOutputLayer or flags.tieOutputLayer is true");
        }
    }

    @Override
    public int domainDimension() {
        if (this.domainDimension < 0) {
            this.originalFeatureCount = 0;
            for (int aMap : this.map) {
                int s = this.labelIndices.get(aMap).size();
                this.originalFeatureCount += s;
            }
            this.domainDimension = 0;
            this.domainDimension += this.inputLayerSize4Edge * this.numEdgeFeatures;
            this.domainDimension += this.inputLayerSize * this.numNodeFeatures;
            this.beforeOutputWeights = this.domainDimension;
            if (this.useOutputLayer) {
                if (this.flags.sparseOutputLayer) {
                    this.domainDimension += this.outputLayerSize4Edge * this.numHiddenUnits;
                    this.domainDimension += this.outputLayerSize * this.numHiddenUnits;
                } else if (this.flags.tieOutputLayer) {
                    this.domainDimension += 1 * this.numHiddenUnits;
                    this.domainDimension += 1 * this.numHiddenUnits;
                } else {
                    this.domainDimension += this.outputLayerSize4Edge * this.inputLayerSize4Edge;
                    this.domainDimension += this.outputLayerSize * this.inputLayerSize;
                }
            }
            log.info("originalFeatureCount: " + this.originalFeatureCount);
            log.info("beforeOutputWeights: " + this.beforeOutputWeights);
            log.info("domainDimension: " + this.domainDimension);
        }
        return this.domainDimension;
    }

    @Override
    public double[] initial() {
        double[] initial = new double[this.domainDimension()];
        if (this.useHiddenLayer || this.useOutputLayer) {
            int i;
            int j;
            double epsilon = 0.1;
            double twoEpsilon = epsilon * 2.0;
            int count = 0;
            double val = 0.0;
            if (this.flags.blockInitialize) {
                int interval4Edge = this.numEdgeFeatures / this.numHiddenUnits;
                for (int i2 = 0; i2 < this.numHiddenUnits; ++i2) {
                    int lower = i2 * interval4Edge;
                    int upper = (i2 + 1) * interval4Edge;
                    if (i2 == this.numHiddenUnits - 1) {
                        upper = this.numEdgeFeatures;
                    }
                    for (j = 0; j < this.outputLayerSize4Edge; ++j) {
                        for (int k = 0; k < this.numEdgeFeatures; ++k) {
                            val = 0.0;
                            if (k >= lower && k < upper) {
                                val = this.random.nextDouble() * twoEpsilon - epsilon;
                            }
                            initial[count++] = val;
                        }
                    }
                }
                int interval = this.numNodeFeatures / this.numHiddenUnits;
                for (int i3 = 0; i3 < this.numHiddenUnits; ++i3) {
                    int lower = i3 * interval;
                    int upper = (i3 + 1) * interval;
                    if (i3 == this.numHiddenUnits - 1) {
                        upper = this.numNodeFeatures;
                    }
                    for (int j2 = 0; j2 < this.outputLayerSize; ++j2) {
                        for (int k = 0; k < this.numNodeFeatures; ++k) {
                            val = 0.0;
                            if (k >= lower && k < upper) {
                                val = this.random.nextDouble() * twoEpsilon - epsilon;
                            }
                            initial[count++] = val;
                        }
                    }
                }
                if (count != this.beforeOutputWeights) {
                    throw new RuntimeException("after blockInitialize, param Index (" + count + ") not equal to beforeOutputWeights (" + this.beforeOutputWeights + ")");
                }
            } else {
                for (i = 0; i < this.beforeOutputWeights; ++i) {
                    val = this.random.nextDouble() * twoEpsilon - epsilon;
                    initial[count++] = val;
                }
            }
            if (this.flags.sparseOutputLayer) {
                int j3;
                for (i = 0; i < this.outputLayerSize4Edge; ++i) {
                    double total = 1.0;
                    for (j3 = 0; j3 < this.numHiddenUnits - 1; ++j3) {
                        val = this.random.nextDouble() * total;
                        initial[count++] = val;
                        total -= val;
                    }
                    initial[count++] = total;
                }
                for (i = 0; i < this.outputLayerSize; ++i) {
                    double total = 1.0;
                    for (j3 = 0; j3 < this.numHiddenUnits - 1; ++j3) {
                        val = this.random.nextDouble() * total;
                        initial[count++] = val;
                        total -= val;
                    }
                    initial[count++] = total;
                }
            } else if (this.flags.tieOutputLayer) {
                double total = 1.0;
                double sum = 0.0;
                for (j = 0; j < this.numHiddenUnits - 1; ++j) {
                    val = this.random.nextDouble() * total;
                    initial[count++] = val;
                    total -= val;
                }
                initial[count++] = total;
                total = 1.0;
                sum = 0.0;
                for (j = 0; j < this.numHiddenUnits - 1; ++j) {
                    val = this.random.nextDouble() * total;
                    initial[count++] = val;
                    total -= val;
                }
                initial[count++] = total;
            } else {
                for (i = this.beforeOutputWeights; i < this.domainDimension(); ++i) {
                    val = this.random.nextDouble() * twoEpsilon - epsilon;
                    initial[count++] = val;
                }
            }
            if (count != this.domainDimension()) {
                throw new RuntimeException("after param initialization, param Index (" + count + ") not equal to domainDimension (" + this.domainDimension() + ")");
            }
        }
        return initial;
    }

    private double[][] emptyU4Edge() {
        int innerSize = this.inputLayerSize4Edge;
        if (this.flags.sparseOutputLayer || this.flags.tieOutputLayer) {
            innerSize = this.numHiddenUnits;
        }
        int outerSize = this.outputLayerSize4Edge;
        if (this.flags.tieOutputLayer) {
            outerSize = 1;
        }
        double[][] temp = new double[outerSize][innerSize];
        for (int i = 0; i < outerSize; ++i) {
            temp[i] = new double[innerSize];
        }
        return temp;
    }

    private double[][] emptyW4Edge() {
        double[][] temp = new double[this.inputLayerSize4Edge][this.numEdgeFeatures];
        for (int i = 0; i < this.inputLayerSize; ++i) {
            temp[i] = new double[this.numEdgeFeatures];
        }
        return temp;
    }

    private double[][] emptyU() {
        int innerSize = this.inputLayerSize;
        if (this.flags.sparseOutputLayer || this.flags.tieOutputLayer) {
            innerSize = this.numHiddenUnits;
        }
        int outerSize = this.outputLayerSize;
        if (this.flags.tieOutputLayer) {
            outerSize = 1;
        }
        double[][] temp = new double[outerSize][innerSize];
        for (int i = 0; i < outerSize; ++i) {
            temp[i] = new double[innerSize];
        }
        return temp;
    }

    private double[][] emptyW() {
        double[][] temp = new double[this.inputLayerSize][this.numNodeFeatures];
        for (int i = 0; i < this.inputLayerSize; ++i) {
            temp[i] = new double[this.numNodeFeatures];
        }
        return temp;
    }

    public Quadruple<double[][], double[][], double[][], double[][]> separateWeights(double[] x) {
        int index = 0;
        double[][] inputLayerWeights4Edge = this.emptyW4Edge();
        for (int i = 0; i < inputLayerWeights4Edge.length; ++i) {
            for (int j = 0; j < inputLayerWeights4Edge[i].length; ++j) {
                inputLayerWeights4Edge[i][j] = x[index++];
            }
        }
        double[][] inputLayerWeights = this.emptyW();
        for (int i = 0; i < inputLayerWeights.length; ++i) {
            for (int j = 0; j < inputLayerWeights[i].length; ++j) {
                inputLayerWeights[i][j] = x[index++];
            }
        }
        double[][] outputLayerWeights4Edge = this.emptyU4Edge();
        for (int i = 0; i < outputLayerWeights4Edge.length; ++i) {
            for (int j = 0; j < outputLayerWeights4Edge[i].length; ++j) {
                outputLayerWeights4Edge[i][j] = this.useOutputLayer ? x[index++] : 1.0;
            }
        }
        double[][] outputLayerWeights = this.emptyU();
        for (int i = 0; i < outputLayerWeights.length; ++i) {
            for (int j = 0; j < outputLayerWeights[i].length; ++j) {
                outputLayerWeights[i][j] = this.useOutputLayer ? x[index++] : 1.0;
            }
        }
        assert (index == x.length);
        return new Quadruple<double[][], double[][], double[][], double[][]>(inputLayerWeights4Edge, outputLayerWeights4Edge, inputLayerWeights, outputLayerWeights);
    }

    @Override
    public CliquePotentialFunction getCliquePotentialFunction(double[] x) {
        Quadruple<double[][], double[][], double[][], double[][]> allParams = this.separateWeights(x);
        double[][] W4Edge = allParams.first();
        double[][] U4Edge = allParams.second();
        double[][] W = allParams.third();
        double[][] U = allParams.fourth();
        return new NonLinearSecondOrderCliquePotentialFunction(W4Edge, U4Edge, W, U, this.flags);
    }

    @Override
    public void calculate(double[] x) {
        block79: {
            int regSize;
            block80: {
                block78: {
                    int i;
                    double prob = 0.0;
                    Quadruple<double[][], double[][], double[][], double[][]> allParams = this.separateWeights(x);
                    double[][] W4Edge = allParams.first();
                    double[][] U4Edge = allParams.second();
                    double[][] W = allParams.third();
                    double[][] U = allParams.fourth();
                    Object Y4Edge = null;
                    Object Y = null;
                    if (this.flags.softmaxOutputLayer) {
                        int i2;
                        Y4Edge = new double[U4Edge.length][];
                        for (i2 = 0; i2 < U4Edge.length; ++i2) {
                            Y4Edge[i2] = ArrayMath.softmax(U4Edge[i2]);
                        }
                        Y = new double[U.length][];
                        for (i2 = 0; i2 < U.length; ++i2) {
                            Y[i2] = ArrayMath.softmax(U[i2]);
                        }
                    }
                    double[][] What4Edge = this.emptyW4Edge();
                    double[][] Uhat4Edge = this.emptyU4Edge();
                    double[][] What = this.emptyW();
                    double[][] Uhat = this.emptyU();
                    double[][] eW4Edge = this.emptyW4Edge();
                    double[][] eU4Edge = this.emptyU4Edge();
                    double[][] eW = this.emptyW();
                    double[][] eU = this.emptyU();
                    for (int m = 0; m < this.data.length; ++m) {
                        int i3;
                        int[][][] docData = this.data[m];
                        int[] docLabels = this.labels[m];
                        NonLinearSecondOrderCliquePotentialFunction cliquePotentialFunction = new NonLinearSecondOrderCliquePotentialFunction(W4Edge, U4Edge, W, U, this.flags);
                        CRFCliqueTree<String> cliqueTree = CRFCliqueTree.getCalibratedCliqueTree(docData, this.labelIndices, this.numClasses, this.classIndex, this.backgroundSymbol, cliquePotentialFunction, null);
                        int[] given = new int[this.window - 1];
                        Arrays.fill(given, this.classIndex.indexOf(this.backgroundSymbol));
                        int[] windowLabels = new int[this.window];
                        Arrays.fill(windowLabels, this.classIndex.indexOf(this.backgroundSymbol));
                        if (docLabels.length > docData.length) {
                            System.arraycopy(docLabels, 0, given, 0, given.length);
                            System.arraycopy(docLabels, 0, windowLabels, 0, windowLabels.length);
                            int[] newDocLabels = new int[docData.length];
                            System.arraycopy(docLabels, docLabels.length - newDocLabels.length, newDocLabels, 0, newDocLabels.length);
                            docLabels = newDocLabels;
                        }
                        for (i3 = 0; i3 < docData.length; ++i3) {
                            int label = docLabels[i3];
                            double p = cliqueTree.condLogProbGivenPrevious(i3, label, given);
                            if (VERBOSE) {
                                log.info("P(" + label + "|" + ArrayMath.toString(given) + ")=" + p);
                            }
                            prob += p;
                            System.arraycopy(given, 1, given, 0, given.length - 1);
                            given[given.length - 1] = label;
                        }
                        for (i3 = 0; i3 < docData.length; ++i3) {
                            System.arraycopy(windowLabels, 1, windowLabels, 0, this.window - 1);
                            windowLabels[this.window - 1] = docLabels[i3];
                            for (int j = 0; j < docData[i3].length; ++j) {
                                int k;
                                int inputSize;
                                Index<CRFLabel> labelIndex = this.labelIndices.get(j);
                                int[] cliqueFeatures = docData[i3][j];
                                double[] As = null;
                                double[] fDeriv = null;
                                double[][] yTimesA = null;
                                double[] sumOfYTimesA = null;
                                int outputSize = -1;
                                if (j == 0) {
                                    inputSize = this.inputLayerSize;
                                    outputSize = this.outputLayerSize;
                                    As = cliquePotentialFunction.hiddenLayerOutput(W, cliqueFeatures, this.flags, null, j + 1);
                                } else {
                                    inputSize = this.inputLayerSize4Edge;
                                    outputSize = this.outputLayerSize4Edge;
                                    As = cliquePotentialFunction.hiddenLayerOutput(W4Edge, cliqueFeatures, this.flags, null, j + 1);
                                }
                                fDeriv = new double[inputSize];
                                double fD = 0.0;
                                for (int q = 0; q < inputSize; ++q) {
                                    fD = this.useSigmoid ? As[q] * (1.0 - As[q]) : 1.0 - As[q] * As[q];
                                    fDeriv[q] = fD;
                                }
                                if (this.flags.softmaxOutputLayer) {
                                    double val = 0.0;
                                    yTimesA = new double[outputSize][this.numHiddenUnits];
                                    for (int ii = 0; ii < outputSize; ++ii) {
                                        yTimesA[ii] = new double[this.numHiddenUnits];
                                    }
                                    sumOfYTimesA = new double[outputSize];
                                    for (int k2 = 0; k2 < outputSize; ++k2) {
                                        double[] Yk = null;
                                        Yk = this.flags.tieOutputLayer ? (j == 0 ? Y[0] : Y4Edge[0]) : (j == 0 ? Y[k2] : Y4Edge[k2]);
                                        double sum = 0.0;
                                        for (int q = 0; q < inputSize; ++q) {
                                            if (q % outputSize != k2) continue;
                                            int hiddenUnitNo = q / outputSize;
                                            yTimesA[k2][hiddenUnitNo] = val = As[q] * Yk[hiddenUnitNo];
                                            sum += val;
                                        }
                                        sumOfYTimesA[k2] = sum;
                                    }
                                }
                                int[] cliqueLabel = new int[j + 1];
                                System.arraycopy(windowLabels, this.window - 1 - j, cliqueLabel, 0, j + 1);
                                CRFLabel crfLabel = new CRFLabel(cliqueLabel);
                                int givenLabelIndex = labelIndex.indexOf(crfLabel);
                                double[] Uk = null;
                                double[] UhatK = null;
                                double[] Yk = null;
                                double[] yTimesAK = null;
                                double sumOfYTimesAK = 0.0;
                                if (this.flags.tieOutputLayer) {
                                    if (j == 0) {
                                        Uk = U[0];
                                        UhatK = Uhat[0];
                                    } else {
                                        Uk = U4Edge[0];
                                        UhatK = Uhat4Edge[0];
                                    }
                                    if (this.flags.softmaxOutputLayer) {
                                        Yk = j == 0 ? Y[0] : Y4Edge[0];
                                    }
                                } else {
                                    if (j == 0) {
                                        Uk = U[givenLabelIndex];
                                        UhatK = Uhat[givenLabelIndex];
                                    } else {
                                        Uk = U4Edge[givenLabelIndex];
                                        UhatK = Uhat4Edge[givenLabelIndex];
                                    }
                                    if (this.flags.softmaxOutputLayer) {
                                        Yk = j == 0 ? Y[givenLabelIndex] : Y4Edge[givenLabelIndex];
                                    }
                                }
                                if (this.flags.softmaxOutputLayer) {
                                    yTimesAK = yTimesA[givenLabelIndex];
                                    sumOfYTimesAK = sumOfYTimesA[givenLabelIndex];
                                }
                                for (k = 0; k < inputSize; ++k) {
                                    int cliqueFeature;
                                    int n;
                                    int n2;
                                    int[] nArray;
                                    double deltaK = 1.0;
                                    if (this.flags.sparseOutputLayer || this.flags.tieOutputLayer) {
                                        if (k % outputSize == givenLabelIndex) {
                                            int hiddenUnitNo = k / outputSize;
                                            if (this.flags.softmaxOutputLayer) {
                                                int n3 = hiddenUnitNo;
                                                UhatK[n3] = UhatK[n3] + (yTimesAK[hiddenUnitNo] - Yk[hiddenUnitNo] * sumOfYTimesAK);
                                                deltaK *= Yk[hiddenUnitNo];
                                            } else {
                                                int n4 = hiddenUnitNo;
                                                UhatK[n4] = UhatK[n4] + As[k];
                                                deltaK *= Uk[hiddenUnitNo];
                                            }
                                        }
                                    } else {
                                        int n5 = k;
                                        UhatK[n5] = UhatK[n5] + As[k];
                                        if (this.useOutputLayer) {
                                            deltaK *= Uk[k];
                                        }
                                    }
                                    if (this.useHiddenLayer) {
                                        deltaK *= fDeriv[k];
                                    }
                                    if (this.useOutputLayer) {
                                        if (this.flags.sparseOutputLayer || this.flags.tieOutputLayer) {
                                            if (k % outputSize != givenLabelIndex) continue;
                                            double[] WhatK = null;
                                            WhatK = j == 0 ? What[k] : What4Edge[k];
                                            nArray = cliqueFeatures;
                                            n2 = nArray.length;
                                            for (n = 0; n < n2; ++n) {
                                                int n6 = cliqueFeature = nArray[n];
                                                WhatK[n6] = WhatK[n6] + deltaK;
                                            }
                                            continue;
                                        }
                                        double[] WhatK = null;
                                        WhatK = j == 0 ? What[k] : What4Edge[k];
                                        nArray = cliqueFeatures;
                                        n2 = nArray.length;
                                        for (n = 0; n < n2; ++n) {
                                            int n7 = cliqueFeature = nArray[n];
                                            WhatK[n7] = WhatK[n7] + deltaK;
                                        }
                                        continue;
                                    }
                                    if (k != givenLabelIndex) continue;
                                    double[] WhatK = null;
                                    WhatK = j == 0 ? What[k] : What4Edge[k];
                                    nArray = cliqueFeatures;
                                    n2 = nArray.length;
                                    for (n = 0; n < n2; ++n) {
                                        int n8 = cliqueFeature = nArray[n];
                                        WhatK[n8] = WhatK[n8] + deltaK;
                                    }
                                }
                                for (k = 0; k < labelIndex.size(); ++k) {
                                    int n;
                                    int[] label = labelIndex.get(k).getLabel();
                                    double p = cliqueTree.prob(i3, label);
                                    double[] Uk2 = null;
                                    double[] eUK = null;
                                    double[] Yk2 = null;
                                    if (this.flags.tieOutputLayer) {
                                        if (j == 0) {
                                            Uk2 = U[0];
                                            eUK = eU[0];
                                        } else {
                                            Uk2 = U4Edge[0];
                                            eUK = eU4Edge[0];
                                        }
                                        if (this.flags.softmaxOutputLayer) {
                                            Yk2 = j == 0 ? Y[0] : Y4Edge[0];
                                        }
                                    } else {
                                        if (j == 0) {
                                            Uk2 = U[k];
                                            eUK = eU[k];
                                        } else {
                                            Uk2 = U4Edge[k];
                                            eUK = eU4Edge[k];
                                        }
                                        if (this.flags.softmaxOutputLayer) {
                                            Yk2 = j == 0 ? Y[k] : Y4Edge[k];
                                        }
                                    }
                                    if (this.useOutputLayer) {
                                        for (int q = 0; q < inputSize; ++q) {
                                            int cliqueFeature;
                                            int n9;
                                            int[] nArray;
                                            double deltaQ = 1.0;
                                            if (this.flags.sparseOutputLayer || this.flags.tieOutputLayer) {
                                                if (q % outputSize == k) {
                                                    int hiddenUnitNo = q / outputSize;
                                                    if (this.flags.softmaxOutputLayer) {
                                                        int n10 = hiddenUnitNo;
                                                        eUK[n10] = eUK[n10] + (yTimesA[k][hiddenUnitNo] - Yk2[hiddenUnitNo] * sumOfYTimesA[k]) * p;
                                                        deltaQ = Yk2[hiddenUnitNo];
                                                    } else {
                                                        int n11 = hiddenUnitNo;
                                                        eUK[n11] = eUK[n11] + As[q] * p;
                                                        deltaQ = Uk2[hiddenUnitNo];
                                                    }
                                                }
                                            } else {
                                                int n12 = q;
                                                eUK[n12] = eUK[n12] + As[q] * p;
                                                deltaQ = Uk2[q];
                                            }
                                            if (this.useHiddenLayer) {
                                                deltaQ *= fDeriv[q];
                                            }
                                            if (this.flags.sparseOutputLayer || this.flags.tieOutputLayer) {
                                                if (q % outputSize != k) continue;
                                                double[] eWq = null;
                                                eWq = j == 0 ? eW[q] : eW4Edge[q];
                                                nArray = cliqueFeatures;
                                                n = nArray.length;
                                                for (n9 = 0; n9 < n; ++n9) {
                                                    int n13 = cliqueFeature = nArray[n9];
                                                    eWq[n13] = eWq[n13] + deltaQ * p;
                                                }
                                                continue;
                                            }
                                            double[] eWq = null;
                                            eWq = j == 0 ? eW[q] : eW4Edge[q];
                                            nArray = cliqueFeatures;
                                            n = nArray.length;
                                            for (n9 = 0; n9 < n; ++n9) {
                                                int n14 = cliqueFeature = nArray[n9];
                                                eWq[n14] = eWq[n14] + deltaQ * p;
                                            }
                                        }
                                        continue;
                                    }
                                    double deltaK = 1.0;
                                    if (this.useHiddenLayer) {
                                        deltaK *= fDeriv[k];
                                    }
                                    double[] eWK = null;
                                    eWK = j == 0 ? eW[k] : eW4Edge[k];
                                    int[] nArray = cliqueFeatures;
                                    int n15 = nArray.length;
                                    for (n = 0; n < n15; ++n) {
                                        int cliqueFeature;
                                        int n16 = cliqueFeature = nArray[n];
                                        eWK[n16] = eWK[n16] + deltaK * p;
                                    }
                                }
                            }
                        }
                    }
                    if (Double.isNaN(prob)) {
                        throw new RuntimeException("Got NaN for prob in CRFNonLinearSecondOrderLogConditionalObjectiveFunction.calculate()");
                    }
                    this.value = -prob;
                    if (VERBOSE) {
                        log.info("value is " + this.value);
                    }
                    int index = 0;
                    for (i = 0; i < eW4Edge.length; ++i) {
                        for (int j = 0; j < eW4Edge[i].length; ++j) {
                            this.derivative[index++] = eW4Edge[i][j] - What4Edge[i][j];
                            if (!VERBOSE) continue;
                            log.info("inputLayerWeights4Edge deriv(" + i + "," + j + ") = " + eW4Edge[i][j] + " - " + What4Edge[i][j] + " = " + this.derivative[index - 1]);
                        }
                    }
                    for (i = 0; i < eW.length; ++i) {
                        for (int j = 0; j < eW[i].length; ++j) {
                            this.derivative[index++] = eW[i][j] - What[i][j];
                            if (!VERBOSE) continue;
                            log.info("inputLayerWeights deriv(" + i + "," + j + ") = " + eW[i][j] + " - " + What[i][j] + " = " + this.derivative[index - 1]);
                        }
                    }
                    if (index != this.beforeOutputWeights) {
                        throw new RuntimeException("after W derivative, index(" + index + ") != beforeOutputWeights(" + this.beforeOutputWeights + ")");
                    }
                    if (this.useOutputLayer) {
                        for (i = 0; i < eU4Edge.length; ++i) {
                            for (int j = 0; j < eU4Edge[i].length; ++j) {
                                this.derivative[index++] = eU4Edge[i][j] - Uhat4Edge[i][j];
                                if (!VERBOSE) continue;
                                log.info("outputLayerWeights4Edge deriv(" + i + "," + j + ") = " + eU4Edge[i][j] + " - " + Uhat4Edge[i][j] + " = " + this.derivative[index - 1]);
                            }
                        }
                        for (i = 0; i < eU.length; ++i) {
                            for (int j = 0; j < eU[i].length; ++j) {
                                this.derivative[index++] = eU[i][j] - Uhat[i][j];
                                if (!VERBOSE) continue;
                                log.info("outputLayerWeights deriv(" + i + "," + j + ") = " + eU[i][j] + " - " + Uhat[i][j] + " = " + this.derivative[index - 1]);
                            }
                        }
                    }
                    if (index != x.length) {
                        throw new RuntimeException("after W derivative, index(" + index + ") != x.length(" + x.length + ")");
                    }
                    regSize = x.length;
                    if (this.flags.skipOutputRegularization || this.flags.softmaxOutputLayer) {
                        regSize = this.beforeOutputWeights;
                    }
                    if (this.prior != 1) break block78;
                    double sigmaSq = this.sigma * this.sigma;
                    int i4 = 0;
                    while (i4 < regSize) {
                        double k = 1.0;
                        double w = x[i4];
                        this.value += k * w * w / 2.0 / sigmaSq;
                        int n = i4++;
                        this.derivative[n] = this.derivative[n] + k * w / sigmaSq;
                    }
                    break block79;
                }
                if (this.prior != 2) break block80;
                double sigmaSq = this.sigma * this.sigma;
                for (int i = 0; i < regSize; ++i) {
                    double w = x[i];
                    double wabs = Math.abs(w);
                    if (wabs < this.epsilon) {
                        this.value += w * w / 2.0 / this.epsilon / sigmaSq;
                        int n = i;
                        this.derivative[n] = this.derivative[n] + w / this.epsilon / sigmaSq;
                        continue;
                    }
                    this.value += (wabs - this.epsilon / 2.0) / sigmaSq;
                    int n = i;
                    this.derivative[n] = this.derivative[n] + (w < 0.0 ? -1.0 : 1.0) / sigmaSq;
                }
                break block79;
            }
            if (this.prior != 3) break block79;
            double sigmaQu = this.sigma * this.sigma * this.sigma * this.sigma;
            int i = 0;
            while (i < regSize) {
                double k = 1.0;
                double w = x[i];
                this.value += k * w * w * w * w / 2.0 / sigmaQu;
                int n = i++;
                this.derivative[n] = this.derivative[n] + k * w / sigmaQu;
            }
        }
    }

    public double[][] emptyFull2D() {
        double[][] d = new double[this.map.length][];
        for (int i = 0; i < this.map.length; ++i) {
            d[i] = new double[this.labelIndices.get(this.map[i]).size()];
        }
        return d;
    }
}

