/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.french;

import edu.stanford.nlp.international.french.FrenchMorphoFeatureSpecification;
import edu.stanford.nlp.international.morph.MorphoFeatureSpecification;
import edu.stanford.nlp.international.morph.MorphoFeatures;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.trees.BobChrisTreeNormalizer;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.international.french.FrenchTreebankLanguagePack;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.Serializable;
import java.util.Collections;
import java.util.function.Predicate;

public class FrenchTreeNormalizer
extends BobChrisTreeNormalizer {
    private static Redwood.RedwoodChannels log = Redwood.channels(FrenchTreeNormalizer.class);
    private static final long serialVersionUID = 7868735300308066991L;
    private final String rootLabel;
    private final MorphoFeatureSpecification morpho = new FrenchMorphoFeatureSpecification();
    private final boolean ccTagset;

    public FrenchTreeNormalizer(boolean ccTagset) {
        super(new FrenchTreebankLanguagePack());
        this.rootLabel = this.tlp.startSymbol();
        this.ccTagset = ccTagset;
        this.aOverAFilter = new FrenchAOverAFilter();
        this.emptyFilter = new Predicate<Tree>(){
            private static final long serialVersionUID = -22673346831392110L;

            @Override
            public boolean test(Tree tree) {
                return !tree.isPreTerminal() || !tree.firstChild().value().equals("") && !tree.firstChild().value().equals("-NONE-");
            }
        };
    }

    @Override
    public String normalizeTerminal(String terminal) {
        if (terminal == null) {
            return terminal;
        }
        if (terminal.equals(")")) {
            return "-RRB-";
        }
        if (terminal.equals("(")) {
            return "-LRB-";
        }
        return super.normalizeTerminal(terminal).intern();
    }

    @Override
    public String normalizeNonterminal(String category) {
        return super.normalizeNonterminal(category).intern();
    }

    private static void replacePOSTag(Tree t, MorphoFeatureSpecification morpho) {
        MorphoFeatures feats;
        if (!t.isPreTerminal()) {
            throw new IllegalArgumentException("Can only operate on preterminals");
        }
        if (!(t.label() instanceof CoreLabel)) {
            throw new IllegalArgumentException("Only operates on CoreLabels");
        }
        CoreLabel label = (CoreLabel)t.label();
        Tree child = t.children()[0];
        if (!(child.label() instanceof CoreLabel)) {
            throw new IllegalArgumentException("Only operates on CoreLabels");
        }
        CoreLabel childLabel = (CoreLabel)child.label();
        String morphStr = childLabel.originalText();
        if (morphStr == null || morphStr.equals("")) {
            morphStr = label.value();
            String subCat = childLabel.category();
            morphStr = subCat != null && subCat != "" ? morphStr + "-" + subCat + "--" : morphStr + "---";
        }
        if ((feats = morpho.strToFeatures(morphStr)).getAltTag() != null && !feats.getAltTag().equals("")) {
            label.setValue(feats.getAltTag());
            label.setTag(feats.getAltTag());
        }
    }

    private String normalizePreterminal(Tree t) {
        if (this.ccTagset) {
            FrenchTreeNormalizer.replacePOSTag(t, this.morpho);
        }
        if (this.tlp.isPunctuationWord(t.firstChild().value())) {
            return this.tlp.punctuationTags()[0].intern();
        }
        return t.value();
    }

    @Override
    public Tree normalizeWholeTree(Tree tree, TreeFactory tf) {
        tree = tree.prune(this.emptyFilter, tf).spliceOut(this.aOverAFilter, tf);
        for (Tree t : tree) {
            if (t.isPreTerminal()) {
                String posStr = this.normalizePreterminal(t);
                t.setValue(posStr);
                if (!(t.label() instanceof HasTag)) continue;
                ((HasTag)((Object)t.label())).setTag(posStr);
                continue;
            }
            if (!t.isLeaf() || !t.value().contains("~#")) continue;
            String[] toks = t.value().split("~#");
            if (toks.length != 2) {
                System.err.printf("%s: Word contains malformed morph annotation: %s%n", this.getClass().getName(), t.value());
                continue;
            }
            if (t.label() instanceof CoreLabel) {
                ((CoreLabel)t.label()).setValue(toks[0].trim().intern());
                ((CoreLabel)t.label()).setWord(toks[0].trim().intern());
                ((CoreLabel)t.label()).setOriginalText(toks[1].trim().intern());
                continue;
            }
            System.err.printf("%s: Cannot store morph analysis in non-CoreLabel: %s%n", this.getClass().getName(), t.label().getClass().getName());
        }
        while (tree != null && (tree.value() == null || tree.value().equals("")) && tree.numChildren() <= 1) {
            tree = tree.firstChild();
        }
        if (tree != null && !tree.value().equals(this.rootLabel)) {
            tree = tf.newTreeNode(this.rootLabel, Collections.singletonList(tree));
        }
        return tree;
    }

    public static class FrenchAOverAFilter
    implements Predicate<Tree>,
    Serializable {
        private static final long serialVersionUID = 793800623099852951L;

        @Override
        public boolean test(Tree t) {
            if (t.value() != null && t.value().equals("w")) {
                return false;
            }
            if (t.isLeaf() || t.isPreTerminal()) {
                return true;
            }
            return t.label() == null || t.label().value() == null || !t.label().value().equals(t.getChild(0).label().value());
        }
    }
}

